"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const allowanceTransfer_1 = require("./allowanceTransfer");
const constants_1 = require("./constants");
describe('AllowanceTransfer', () => {
    describe('Max values', () => {
        it('max values pass', () => {
            expect(() => allowanceTransfer_1.AllowanceTransfer.hash({
                details: {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: constants_1.MaxAllowanceTransferAmount.toString(),
                    expiration: constants_1.MaxAllowanceExpiration.toString(),
                    nonce: constants_1.MaxOrderedNonce.toString(),
                },
                spender: '0x0000000000000000000000000000000000000000',
                sigDeadline: constants_1.MaxSigDeadline.toString(),
            }, '0x0000000000000000000000000000000000000000', 1)).not.toThrow();
        });
        it('nonce out of range', () => {
            expect(() => allowanceTransfer_1.AllowanceTransfer.hash({
                details: {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: '0',
                    expiration: '0',
                    nonce: constants_1.MaxOrderedNonce.add(1).toString(),
                },
                spender: '0x0000000000000000000000000000000000000000',
                sigDeadline: '0',
            }, '0x0000000000000000000000000000000000000000', 1)).toThrow('NONCE_OUT_OF_RANGE');
        });
        it('amount out of range', () => {
            expect(() => allowanceTransfer_1.AllowanceTransfer.hash({
                details: {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: constants_1.MaxAllowanceTransferAmount.add(1).toString(),
                    expiration: '0',
                    nonce: 0,
                },
                spender: '0x0000000000000000000000000000000000000000',
                sigDeadline: '0',
            }, '0x0000000000000000000000000000000000000000', 1)).toThrow('AMOUNT_OUT_OF_RANGE');
        });
        it('expiration out of range', () => {
            expect(() => allowanceTransfer_1.AllowanceTransfer.hash({
                details: {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: '0',
                    expiration: constants_1.MaxAllowanceExpiration.add(1).toString(),
                    nonce: 0,
                },
                spender: '0x0000000000000000000000000000000000000000',
                sigDeadline: '0',
            }, '0x0000000000000000000000000000000000000000', 1)).toThrow('EXPIRATION_OUT_OF_RANGE');
        });
        it('sigDeadline out of range', () => {
            expect(() => allowanceTransfer_1.AllowanceTransfer.hash({
                details: {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: '0',
                    expiration: '0',
                    nonce: 0,
                },
                spender: '0x0000000000000000000000000000000000000000',
                sigDeadline: constants_1.MaxSigDeadline.add(1).toString(),
            }, '0x0000000000000000000000000000000000000000', 1)).toThrow('SIG_DEADLINE_OUT_OF_RANGE');
        });
    });
    it('non-batch', () => {
        expect(allowanceTransfer_1.AllowanceTransfer.hash({
            details: {
                token: '0x0000000000000000000000000000000000000000',
                amount: '0',
                expiration: '0',
                nonce: 0,
            },
            spender: '0x0000000000000000000000000000000000000000',
            sigDeadline: '0',
        }, '0x0000000000000000000000000000000000000000', 1)).toBe('0xd47437bffdbc4d123a2165feb6ca646b8700c038622ce304f84e9048bc744f36');
    });
    it('batch', () => {
        expect(allowanceTransfer_1.AllowanceTransfer.hash({
            details: [
                {
                    token: '0x0000000000000000000000000000000000000000',
                    amount: '0',
                    expiration: '0',
                    nonce: 0,
                },
            ],
            spender: '0x0000000000000000000000000000000000000000',
            sigDeadline: '0',
        }, '0x0000000000000000000000000000000000000000', 1)).toBe('0x49642ada5f77eb9458f8265eb01fed2684c2f25d50534fea3efdf2cf395deb2f');
    });
});
//# sourceMappingURL=allowanceTransfer.test.js.map